/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.scriptconsole.GuiExceptionHandler;
import org.das2.util.ExceptionHandler;

public class DumpRteExceptionHandler
implements ExceptionHandler {
    public void handle(Throwable t) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("throwable", t);
        data.put("EMAIL", "otto@autoplot.org");
        data.put("INCLDOM", Boolean.TRUE);
        String s = GuiExceptionHandler.formatReport(data, true, "DumpRteExceptionHandler generated this");
        int rteHash = GuiExceptionHandler.hashCode(t);
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String eventId = sdf.format(now);
        String id = System.getProperty("user.name");
        String fname = String.format("rte_%010d_%s_%s.xml", rteHash, eventId, id);
        File file = new File(fname).getAbsoluteFile();
        try (FileWriter f = new FileWriter(file);){
            f.write(s);
        }
        catch (IOException ex) {
            Logger.getLogger(DumpRteExceptionHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.err.println("##### Exception written to " + file);
    }

    public void handleUncaught(Throwable t) {
        this.handle(t);
    }
}

